/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.GunMod;
import com.tacz.guns.util.UriEncoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GetJarResources {
    private GetJarResources() {
    }

    public static void copyModFile(String srcPath, Path root, String path) {
        URL url = GunMod.class.getResource(srcPath);
        try {
            if (url != null) {
                FileUtils.copyURLToFile((URL)url, (File)root.resolve(path).toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyModDirectory(Class<?> resourceClass, String srcPath, Path root, String path) {
        URL url = resourceClass.getResource(srcPath);
        try {
            if (url != null) {
                GetJarResources.copyFolder(url.toURI(), root.resolve(path));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyModDirectory(String srcPath, Path root, String path) {
        GetJarResources.copyModDirectory(GunMod.class, srcPath, root, path);
    }

    @Nullable
    public static InputStream readModFile(String filePath) {
        URL url = GunMod.class.getResource(filePath);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void copyFolder(URI sourceURI, Path targetPath) throws IOException {
        if (Files.isDirectory(targetPath, new LinkOption[0])) {
            GetJarResources.deleteFiles(targetPath);
        }
        try (Stream<Path> stream = Files.walk(Paths.get(sourceURI), Integer.MAX_VALUE, new FileVisitOption[0]);){
            stream.forEach(source -> {
                Path target = GetJarResources.getTargetPath(sourceURI, targetPath, source);
                try {
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @NotNull
    private static Path getTargetPath(URI sourceURI, Path targetPath, Path source) {
        String relativize = sourceURI.relativize(source.toUri()).toString();
        if (Objects.equals(sourceURI.getScheme(), "jar")) {
            URI pSourceURI = URI.create(UriEncoder.encode(sourceURI.getSchemeSpecificPart()));
            URI pSource = URI.create(UriEncoder.encode(source.toUri().getSchemeSpecificPart()));
            relativize = pSourceURI.relativize(pSource).toString();
        }
        return targetPath.resolve(relativize);
    }

    private static void deleteFiles(Path targetPath) throws IOException {
        Files.walkFileTree(targetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

